local assets =
{ 
    Asset("ANIM", "anim/ehardhat.zip"),
    Asset("ANIM", "anim/ehardhat_swap.zip"),  

    Asset("ATLAS", "images/inventoryimages/ehardhat.xml"),
    Asset("IMAGE", "images/inventoryimages/ehardhat.tex"),
}

local prefabs = 
{
}

local function OnEquip(inst, owner) 
        owner.AnimState:OverrideSymbol("swap_hat", "ehardhat_swap", "swap_hat")
        owner.AnimState:Show("HAT")
        owner.AnimState:Show("HAT_HAIR")
        owner.AnimState:Hide("HAIR_NOHAT")
        owner.AnimState:Hide("HAIR")
        
        if owner:HasTag("player") then
            owner.AnimState:Show("HEAD_HAIR")
        end
end

local function OnUnequip(inst, owner)
        owner.AnimState:ClearOverrideSymbol("swap_hat")
        owner.AnimState:Hide("HAT")
        owner.AnimState:Hide("HAT_HAIR")
        owner.AnimState:Show("HAIR_NOHAT")
        owner.AnimState:Show("HAIR")

        if owner:HasTag("player") then
            owner.AnimState:Show("HEAD")
            owner.AnimState:Hide("HEAD_HAIR")
        end
end

local function fn()

    local inst = CreateEntity()
    local trans = inst.entity:AddTransform()
    local anim = inst.entity:AddAnimState()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("ehardhat")
    inst.AnimState:SetBuild("ehardhat")
    inst.AnimState:PlayAnimation("idle")

    inst:AddTag("hat")

    inst:AddComponent("inspectable")
    inst:AddComponent("tradable")

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "ehardhat"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/ehardhat.xml"
    
    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.HEAD
    inst.components.equippable:SetOnEquip(OnEquip)
    inst.components.equippable:SetOnUnequip(OnUnequip)
	
    inst:AddComponent("armor")
    inst.components.armor:InitCondition(TUNING.ARMOR_EHARDHAT, TUNING.ARMOR_HARDHAT_ABSORPTION)

    return inst
end

return  Prefab("common/inventory/ehardhat", fn, assets, prefabs)